#include <iostream>
#include <vector>
#include <algorithm>

typedef std::pair<long long, long long> jarbol;

int main()
{
    int n;
    std::cin >> n;

    std::vector<jarbol> jarboli(n);

    for (int i = 0; i < n; i++)
        std::cin >> jarboli[i].first;

    for (int i = 0; i < n; i++)
        std::cin >> jarboli[i].second;

    std::sort(jarboli.begin(), jarboli.end());

    int top = 0;
    std::vector<std::pair<jarbol, jarbol>> stek(n);

    std::vector<long long> brojilacRazlomka(n);
    std::vector<long long> imenilacRazlomka(n);
    for (int i = 0; i < n; i++)
    {
        brojilacRazlomka[i] = -1;
        imenilacRazlomka[i] = 1;
    }

    top = 0;

    for (int i = 1; i < n; i++)
    {
        jarbol leviPocetak = jarboli[i];
        jarbol leviKraj = jarboli[i - 1];

        while (top > 0)
        {
            jarbol stariPocetak = stek[top - 1].first;
            jarbol stariKraj = stek[top - 1].second;

            long long donjaNova = std::min(leviPocetak.second, leviKraj.second);
            long long donjaStara = std::min(stariPocetak.second, stariKraj.second);
            long long H = std::max(donjaNova, donjaStara);

            if (std::max(leviPocetak.second, leviKraj.second) < H ||
                std::max(stariPocetak.second, stariKraj.second) < H)
                break;

            double xNovi =
                leviPocetak.first +
                (double)(H - leviPocetak.second) *
                (leviKraj.first - leviPocetak.first) /
                (leviKraj.second - leviPocetak.second);

            double xStari =
                stariPocetak.first +
                (double)(H - stariPocetak.second) *
                (stariKraj.first - stariPocetak.first) /
                (stariKraj.second - stariPocetak.second);

            if (xNovi >= xStari)
                top--;
            else
                break;
        }

        stek[top] = { leviPocetak, leviKraj };
        top++;

        if (std::max(leviPocetak.second, leviKraj.second) >= jarboli[i].second)
        {
            double xPresek =
                leviPocetak.first +
                (double)(jarboli[i].second - leviPocetak.second) *
                (leviKraj.first - leviPocetak.first) /
                (leviKraj.second - leviPocetak.second);

            double udaljenost = jarboli[i].first - xPresek;

            if (brojilacRazlomka[i] == -1 || udaljenost < (double)brojilacRazlomka[i] / imenilacRazlomka[i])
            {
                brojilacRazlomka[i] = (long long)(udaljenost * 1000000);
                imenilacRazlomka[i] = 1000000;
            }
        }
    }

    std::cout << "-1" << std::endl;
}